/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.SQLException;
import java.time.Duration;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.datasources.AbstractConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

final class KeyedCPDSConnectionFactory
extends AbstractConnectionFactory
implements KeyedPooledObjectFactory<UserPassKey, PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool;

    KeyedCPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, Duration duration, boolean bl) {
        super(connectionPoolDataSource, string, duration, bl);
    }

    @Override
    public void activateObject(UserPassKey userPassKey, PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
    }

    @Override
    public void closePool(String string) throws SQLException {
        try {
            this.pool.clear(new UserPassKey(string));
        }
        catch (Exception exception) {
            throw new SQLException("Error closing connection pool", exception);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingSet.contains(pooledConnection)) {
            PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
            if (pooledConnectionAndInfo == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this.pool.returnObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pooledConnection.removeConnectionEventListener(this);
                try {
                    this.pool.invalidateObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + String.valueOf(pooledConnectionAndInfo));
                    exception2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + String.valueOf(connectionEvent.getSQLException()) + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + String.valueOf(pooledConnectionAndInfo));
            exception.printStackTrace();
        }
    }

    @Override
    public void destroyObject(UserPassKey userPassKey, PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        PooledConnection pooledConnection = pooledObject.getObject().getPooledConnection();
        pooledConnection.removeConnectionEventListener(this);
        this.pcMap.remove(pooledConnection);
        pooledConnection.close();
    }

    public KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> getPool() {
        return this.pool;
    }

    @Override
    public void invalidate(PooledConnection pooledConnection) throws SQLException {
        PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        UserPassKey userPassKey = pooledConnectionAndInfo.getUserPassKey();
        try {
            this.pool.invalidateObject(userPassKey, pooledConnectionAndInfo);
            this.pool.clear(userPassKey);
        }
        catch (Exception exception) {
            throw new SQLException("Error invalidating connection", exception);
        }
    }

    @Override
    public synchronized PooledObject<PooledConnectionAndInfo> makeObject(UserPassKey userPassKey) throws SQLException {
        PooledConnection pooledConnection = null;
        String string = userPassKey.getUserName();
        String string2 = userPassKey.getPassword();
        pooledConnection = string == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(string, string2);
        if (pooledConnection == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pooledConnection.addConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, userPassKey);
        this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        return new DefaultPooledObject<PooledConnectionAndInfo>(pooledConnectionAndInfo);
    }

    @Override
    public void passivateObject(UserPassKey userPassKey, PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
    }

    @Override
    public void setPassword(char[] cArray) {
    }

    @Override
    public void setPassword(String string) {
    }

    public void setPool(KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> keyedObjectPool) {
        this.pool = keyedObjectPool;
    }

    @Override
    public boolean validateObject(UserPassKey userPassKey, PooledObject<PooledConnectionAndInfo> pooledObject) {
        return super.validateObject(pooledObject);
    }
}

